require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Aiming"

ST.addContributor(KEY, function(ctx)
    local level = ctx.getLevel()

    -- Wiki: at Aiming 5+, XP gain reduced to ~37%
    if level >= 5 then
        ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
        ctx.add(ST.getText("IGUI_DST_Aiming_note_XP"))
    end

    -- Wiki: at Aiming 6+, panic debuff no longer affects guns
    if level >= 6 then
        ctx.add(ST.getText("IGUI_DST_Aiming_note_Panic"))
    end
end)